#include <string.h>
#include <errno.h>
#include <stdio.h>
#include <unistd.h>
#include <sys/param.h>
#include "hxd.h"
#include "xmalloc.h"

#if defined(CONFIG_EXEC)

struct exec_file {
	struct htlc_conn *htlc;
	u_int32_t cid;
};

fd_set exec_fds;

static void
exec_close (int fd)
{
	close(fd);
	nr_open_files--;
	xfree(hxd_files[fd].conn.ptr);
	memset(&hxd_files[fd], 0, sizeof(struct hxd_file));
	FD_CLR(fd, &hxd_rfds);
	FD_CLR(fd, &exec_fds);
	if (high_fd == fd) {
		for (fd--; fd && !FD_ISSET(fd, &hxd_rfds); fd--)
			;
		high_fd = fd;
	}
}

void
exec_close_all (struct htlc_conn *htlc)
{
	struct exec_file *execp;
	int i;

	for (i = 0; i <= high_fd; i++) {
		if (FD_ISSET(i, &exec_fds)) {
			execp = (struct exec_file *)hxd_files[i].conn.ptr;
			if (execp->htlc == htlc)
				exec_close(i);
		}
	}
}

void
exec_init (void)
{
	FD_ZERO(&exec_fds);
}

static void
exec_ready_read (int fd)
{
	struct exec_file *execp = (struct exec_file *)hxd_files[fd].conn.ptr;
	ssize_t r;
	u_int8_t buf[16384];

	r = read(fd, buf, sizeof(buf));
	if (r <= 0)
		exec_close(fd);
	else {
		if (execp->cid) {
			u_int32_t ncid = htonl(execp->cid);
			hlwrite(execp->htlc, HTLS_HDR_CHAT, 0, 3,
				HTLS_DATA_CHAT, r, buf,
				HTLS_DATA_CHAT_ID, 4, &ncid,
				HTLS_DATA_UID, 2, "\0\0");
		} else {
			hlwrite(execp->htlc, HTLS_HDR_CHAT, 0, 2,
				HTLS_DATA_CHAT, r, buf,
				HTLS_DATA_UID, 2, "\0\0");
		}
	}
}

#if 0 /* add somethin like http post here?? */
static void
exec_ready_write (int fd)
{
}
#endif

#define log_exec 0

static void
cmd_exec (struct htlc_conn *htlc, u_int32_t cid, char *command)
{
	int argc, pfds[2];
	char *argv[32], *p, *pii, *thisarg, cmdpath[MAXPATHLEN];
	struct exec_file *execp;

	while ((p = strstr(command, "../"))) {
		for (pii = p; *pii; pii++)
			*pii = *(pii + 3);
	}

	for (argc = 0, thisarg = p = command; *p && argc < 30; p++) {
		if (*p == ' ') {
			*p = 0;
			argv[argc++] = thisarg;
			thisarg = p + 1;
		}
	}
	if (thisarg != p)
		argv[argc++] = thisarg;
	argv[argc] = 0;
	snprintf(cmdpath, sizeof(cmdpath), "%s/%s", hxd_cfg.paths.exec, argv[0]);

	if (log_exec)
		hxd_log("%s execs %s", htlc->name, cmdpath);
	if (pipe(pfds)) {
		hxd_log("cmd_exec: pipe: %s", strerror(errno));
		return;
	}
	nr_open_files += 2;
	if (nr_open_files >= hxd_open_max) {
		hxd_log("%s:%d: %d >= hxd_open_max (%d)", __FILE__, __LINE__, pfds[0], hxd_open_max);
		close(pfds[0]);
		close(pfds[1]);
		nr_open_files -= 2;
		return;
	}
	switch (fork()) {
		case -1:
			hxd_log("cmd_exec: fork: %s", strerror(errno));
			close(pfds[0]);
			close(pfds[1]);
			nr_open_files -= 2;
			return;
		case 0:
			if (dup2(pfds[1], 1) == -1 || dup2(pfds[1], 2) == -1) {
				hxd_log("cmd_exec: dup2: %s", strerror(errno));
				_exit(1);
			}
			close(0);
#if 0
			{
				int i;

				fprintf(stderr, "executing");
				for (i = 0; i < argc; i++)
					fprintf(stderr, " %s", argv[i]);
			}
#endif
			{
				char *envp[2], rootdir[MAXPATHLEN + 16];

				snprintf(rootdir, sizeof(rootdir), "ROOTDIR=%s", htlc->rootdir);
				envp[0] = rootdir;
				envp[1] = 0;
				execve(cmdpath, argv, envp);
			}
			fprintf(stderr, "\r%s: %s", argv[0], strerror(errno));
			_exit(1);
		default:
			close(pfds[1]);
			nr_open_files--;
			FD_SET(pfds[0], &exec_fds);
			execp = xmalloc(sizeof(struct exec_file));
			execp->htlc = htlc;
			execp->cid = cid;
			hxd_files[pfds[0]].conn.ptr = (void *)execp;
			hxd_files[pfds[0]].ready_read = exec_ready_read;
			FD_SET(pfds[0], &hxd_rfds);
			if (high_fd < pfds[0])
				high_fd = pfds[0];
			break;
	}
}
#endif /* ndef CONFIG_EXEC */

static void
update_user (struct htlc_conn *htlc)
{
	struct htlc_conn *htlcp;
	u_int16_t uid, icon16, color;

	uid = htons(mangle_uid(htlc));
	icon16 = htons(htlc->icon);
	color = htons(htlc->color);
	for (htlcp = htlc_list->next; htlcp; htlcp = htlcp->next) {
		if (!htlcp->access_extra.user_getlist)
			continue;
		hlwrite(htlcp, HTLS_HDR_USER_CHANGE, 0, 4,
			HTLS_DATA_UID, sizeof(uid), &uid,
			HTLS_DATA_ICON, sizeof(icon16), &icon16,
			HTLS_DATA_COLOR, sizeof(color), &color,
			HTLS_DATA_NAME, strlen(htlc->name), htlc->name);
	}
}

void
toggle_away (struct htlc_conn *htlc)
{
	htlc->color = htlc->color & 1 ? htlc->color-1 : htlc->color+1;
	if (!htlc->flags.visible)
		return;
#if defined(CONFIG_SQL)
	sql_modify_user(htlc->name, htlc->icon, htlc->color, htlc->uid);
#endif
	update_user(htlc);
}

static void
cmd_broadcast (struct htlc_conn *htlc, char *chatbuf)
{
	u_int16_t style, len;
	struct htlc_conn *htlcp;

	if (!htlc->access.can_broadcast)
		return;

	style = htons(1);
	len = strlen(chatbuf);
	for (htlcp = htlc_list->next; htlcp; htlcp = htlcp->next)
		hlwrite(htlcp, HTLS_HDR_MSG, 0, 2,
			HTLS_DATA_STYLE, 2, &style,
			HTLS_DATA_MSG, len, chatbuf);
}

static void
cmd_visible (struct htlc_conn *htlc)
{
	u_int16_t uid16;
	struct htlc_conn *htlcp;

	if (!htlc->access_extra.user_visibility)
		return;

	htlc->flags.visible = !htlc->flags.visible;
	if (!htlc->flags.visible) {
		uid16 = htons(mangle_uid(htlc));
		for (htlcp = htlc_list->next; htlcp; htlcp = htlcp->next) {
			if (!htlcp->access_extra.user_getlist)
				continue;
			hlwrite(htlcp, HTLS_HDR_USER_PART, 0, 1,
				HTLS_DATA_UID, sizeof(uid16), &uid16);
		}
	} else {
		update_user(htlc);
	}
}

static void
cmd_color (struct htlc_conn *htlc, char *chatbuf)
{
	u_int16_t color = htlc->color;

	if (!htlc->access_extra.user_color)
		return;

	htlc->color = strtoul(chatbuf, 0, 0);
#if defined(CONFIG_SQL)
	sql_modify_user(htlc->name, htlc->icon, htlc->color, htlc->uid);
#endif
	if (htlc->color != color && htlc->flags.visible)
		update_user(htlc);
}

extern void access_extra_set (struct extra_access_bits *acc, char *p, int val);

static void
cmd_access (struct htlc_conn *htlc, char *chatbuf)
{
	char *p, *str;
	u_int32_t uid;
	int val;
	struct htlc_conn *htlcp;

	if (!htlc->access_extra.user_access)
		return;

	p = chatbuf;
	uid = atou32(p);
	if (!uid)
		return;
	htlcp = isclient(htlc->sid, uid);
	if (!htlcp)
		return;
	if (!htlcp->access_extra.access_volatile)
		return;
	while (*p && *p != ' ')
		p++;
	while (*p && *p == ' ')
		p++;
	while (*p) {
		str = p;
		p = strchr(p, '=');
		if (!p)
			break;
		*p = 0;
		p++;
		val = *p == '1' ? 1 : 0;
		p++;
		access_extra_set(&htlcp->access_extra, str, val);
		while (*p && *p != ' ')
			p++;
		while (*p && *p == ' ')
			p++;
	}
}

static int
user_0wn (struct htlc_conn *htlc, char *str, char *p)
{
	if (!strcmp(str, "icon")) {
		u_int16_t icon;

		icon = strtoul(p, 0, 0);
		htlc->icon = icon;
		return 1;
	} else if (!strcmp(str, "color")) {
		u_int16_t color;

		color = strtoul(p, 0, 0);
		htlc->color = color;
		return 2;
	} else if (!strcmp(str, "name")) {
		size_t len;

		/* copies the rest of the command into name! */
		len = strlen(p);
		if (len > sizeof(htlc->name)-1)
			len = sizeof(htlc->name)-1;
		memcpy(htlc->name, p, len);
		htlc->name[len] = 0;
		return 3;
	}

	return 0;
}

static void
cmd_0wn (struct htlc_conn *htlc, char *chatbuf)
{
	char *p, *str;
	u_int32_t uid;
	int x, n;
	struct htlc_conn *htlcp;

	if (!htlc->access_extra.user_0wn)
		return;

	p = chatbuf;
	uid = atou32(p);
	if (!uid)
		return;
	htlcp = isclient(htlc->sid, uid);
	if (!htlcp)
		return;
	if (!htlcp->access_extra.is_0wn3d)
		return;
	while (*p && *p != ' ')
		p++;
	while (*p && *p == ' ')
		p++;
	n = 0;
	while (*p) {
		str = p;
		p = strchr(p, '=');
		if (!p)
			break;
		*p = 0;
		p++;
		x = user_0wn(htlcp, str, p);
		if (x) {
			n++;
			if (x == 3)
				break;
		}
		while (*p && *p != ' ')
			p++;
		while (*p && *p == ' ')
			p++;
	}
	if (n)
		update_user(htlcp);
}

static void
cmd_mon (struct htlc_conn *htlc, char *chatbuf)
{
	struct htlc_conn *htlcp;
	u_int32_t uid;

	if (!htlc->access.disconnect_users)
		return;

	uid = atou32(chatbuf);
	htlcp = isclient(htlc->sid, uid);
	if (!htlcp)
		return;
	if (!htlcp->access_extra.access_volatile)
		return;
	htlcp->access_extra.msg = 1;
	htlcp->access.send_msgs = 1;
}

static void
cmd_notfound (struct htlc_conn *htlc, u_int32_t cid, char *chatbuf)
{
	char *p, buf[256];
	int len;

	p = strchr(chatbuf, ' ');
	if (p)
		len = p - chatbuf;
	else
		len = strlen(chatbuf);
	len = snprintf(buf, sizeof(buf), "\rcommand not found: %.*s", len, chatbuf);
	if (len == -1)
		len = sizeof(buf);
	if (cid) {
		u_int32_t ncid = htonl(cid);
		hlwrite(htlc, HTLS_HDR_CHAT, 0, 3,
			HTLS_DATA_CHAT, len, buf,
			HTLS_DATA_CHAT_ID, 4, &ncid,
			HTLS_DATA_UID, 2, "\0\0");
	} else {
		hlwrite(htlc, HTLS_HDR_CHAT, 0, 2,
			HTLS_DATA_CHAT, len, buf,
			HTLS_DATA_UID, 2, "\0\0");
	}
}

/* chatbuf points to the auto array in rcv_chat + 1 */
void
command_chat (struct htlc_conn *htlc, u_int32_t cid, char *chatbuf)
{
	switch (chatbuf[0]) {
		case '0':
			if (!strncmp(chatbuf, "0wn ", 4) && chatbuf[4]) {
				cmd_0wn(htlc, &chatbuf[4]);
				return;
			}
			break;
		case 'a':
			if (!strncmp(chatbuf, "access ", 7) && chatbuf[7]) {
				cmd_access(htlc, &chatbuf[7]);
				return;
			} else if (!strncmp(chatbuf, "away", 4)) {
				if (htlc->flags.away == AWAY_INTERRUPTED)
					break;
				toggle_away(htlc);
				if (!htlc->flags.away)
					htlc->flags.away = AWAY_PERM;
				else
					htlc->flags.away = 0;
				if (hxd_cfg.options.away_time) {
					timer_delete_ptr(htlc);
					if (!htlc->flags.away)
						timer_add_secs(hxd_cfg.options.away_time, away_timer, htlc);
				}
				return;
			}
			break;
		case 'b':
			if (!strncmp(chatbuf, "broadcast ", 10) && chatbuf[10]) {
				cmd_broadcast(htlc, &chatbuf[10]);
				return;
			}
		case 'c':
			if (!strncmp(chatbuf, "color ", 6) && chatbuf[6]) {
				cmd_color(htlc, &chatbuf[6]);
				return;
			}
#if defined(CONFIG_EXEC)
		case 'e':
			if (!strncmp(chatbuf, "exec ", 5) && chatbuf[5]) {
				cmd_exec(htlc, cid, &chatbuf[5]);
				return;
			}
			break;
		case 'f':
			if (!strncmp(chatbuf, "find", 4)) {
				cmd_exec(htlc, cid, chatbuf);
				return;
			}
			break;
#endif
		case 'g':
			if (!strncmp(chatbuf, "g0away", 6)) {
				cmd_visible(htlc);
				return;
			}
			break;
		case 'v':
			if (!strncmp(chatbuf, "visible", 7)) {
				cmd_visible(htlc);
				return;
			}
			break;
		case 'm':
#if XMALLOC_DEBUG
			if (!strncmp(chatbuf, "maltbl", 6) && htlc->access_extra.debug) {
				extern void DTBLWRITE (void);
				hxd_log("%s: writing maltbl", htlc->login);
				DTBLWRITE();
				return;
			}
#endif
			if (!strncmp(chatbuf, "mon ", 4) && chatbuf[4]) {
				cmd_mon(htlc, &chatbuf[4]);
				return;
			}
			break;
		default:
			break;
	}
	cmd_notfound(htlc, cid, chatbuf);
}
